"use client";

import * as React from "react";
import { useTranslations } from "next-intl";
import { useForm, Controller } from "react-hook-form";
import { Input } from "@/components/ui/input";
import { Select, SelectTrigger, SelectValue, SelectContent, SelectItem } from "@/components/ui/select";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";
import { API_ENDPOINTS } from "@/lib/api/endpoints";
import { useGenericTable } from "@/lib/hooks/useGenericTable";
import SubmitBtnClient from "@/components/submit-client-button";
import { RenderFields } from "@/components/common/dynamicForm";
import { Calculator, IndianRupee, Package, Save, TrendingUp } from "lucide-react";
import { StockAdjustmentItemsTable } from "@/components/inventory/itemSelectRow";
import { LinkAsButton } from "@/components/ui/link-button";
import { Card, CardHeader, CardTitle, CardContent } from "@/components/ui/card";
import { useRouter } from "next/navigation";
import { StockAdjustmentItemsTableView } from "@/components/inventory/itemViewRow";
import { use } from "react";
import { Table, TableHeader, TableRow, TableHead, TableBody, TableCell } from "@/components/ui/table";
import { StockAdjustmentUsageTable } from "@/components/inventory/itemUsageRow";
import { StockAdjustmentUsageTableEdit } from "@/components/inventory/itemUsageRowEdit";

interface StockAdjustmentViewProps {
  params: Promise<{
    id: string;
  }>,
  searchParams: Promise<{
    user?: string;
  }>;
}

export default function StockStockUsageView({ params }: StockAdjustmentViewProps) {
  const { id } = use(params);
  const t = useTranslations("StockUsage");
  const router = useRouter();

  // Initialize table + form handling
  const url = API_ENDPOINTS.INVENTORY.STOCK_USAGE;
  const { save, loading, create, getItem, update } = useGenericTable({ url });
  const methods = useForm<any>();
  const [redering, setRedering] = React.useState<boolean>(true);
  const { control, handleSubmit, reset, setValue, watch } = methods;

  const dynamicFields = [
    { key: "quantity", type: "number", },
    { key: "unit_cost", type: "number" },
    { key: "note", type: "text" },
  ];

  // Define fields in your pattern
  const [fields, setFields] = React.useState<any[]>([]);
  const [oldFields, setOld] = React.useState<any>();

  let totalValue = 0;
  React.useEffect(() => {
    (async () => {
      try {
        const data: any = await create("-create");
        const viewData: any = await getItem(id);


        debugger;
        const formatted = viewData?.items.map((item: any) => ({
          item_id: item.item_id,
          unit_id: item.unit_id,
          quantity: item.quantity,
          multiplier: item.multiplier,
          note: item.note,
          item: item.item,
          unit_cost: item.batch.cost_price,
          available_stock: item.batch.quantity,
          base_unit: item.unit.unit_id,
          batch_number: item.batch.id,
          batch: item.batch,
          unit: item.unit,
          is_new: 0,

        }));

        setOld(formatted);


        setFields([
          {
            label: t("date"),
            data: {
              type: "date",
              props: [],
              key: "usage_date",
              value: ""
            }
          },
          {
            label: t("selectStore"),
            data: {
              type: "select",
              props: data?.stores?.map((s: any) => ({ value: String(s.id), label: s.store_name })),
              key: "from_store_id",
              value: ""
            }
          },
          {
            label: t("status"),
            data: {
              type: "select",
              props: data?.status?.map((s: any) => ({ value: String(s.id), label: s.name })),
              key: "status",
              value: ""
            }
          },
          {
            label: t("notes"),
            data: {
              type: "textarea",
              props: [],
              key: "notes",
              value: ""
            }
          }
          // Add other fields if needed

        ]);
        setValue('notes', viewData?.notes)
        setValue('from_store_id', String(viewData?.store_id))
        setValue('usage_date', viewData?.usage_date)
        setValue('status', String(viewData?.status))
        setRedering(false);
      } catch (error) {
        console.error("Failed to fetch stock usage options:", error);
      }
    })();
  }, []);


  // Submit handler
  const onSubmit = async (data: any) => {
    debugger;
    try {
      await update(id, data);
      reset();
      router.push("/inventory/stock/usage");
    } catch (error) {
      console.error(error);
    }
  };

  return (
    <form className="space-y-4">
      <div className="flex items-center justify-between">
        <h1 className="text-2xl font-semibold">{t("edit_transfer")}</h1>
      </div>


      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <RenderFields fields={fields} control={control} register={methods.register} t={t} redering={redering} setValue={setValue} />
      </div>

      <StockAdjustmentUsageTableEdit
        control={control}
        watch={watch}
        methods={methods}
        setValue={setValue}
        dynamicFields={dynamicFields}
        oldFields={oldFields}
        t={t}
      />
      <div className="mt-6 flex justify-end gap-2">
        <LinkAsButton href="/inventory/stock/adjustment" variant={"outline"} >{t("cancel")}</LinkAsButton>
        <SubmitBtnClient isLoading={loading} onClick={handleSubmit(onSubmit)} ><Save />{t("save")}</SubmitBtnClient>
      </div>
    </form>
  );
}
